#TEMPLATE(JtCplT,'JaDu Technologies Control Panel Template'),FAMILY('ABC')
#PROCEDURE(JtCPl,'JaDu Technologies Control, Panel Procedure')
#DECLARE(%JtCplTotalProcedures)
#DECLARE(%JtCplRes1)
#DECLARE(%JtCplRes2)
#RESTRICT
  #IF(upper(%ProgramExtension) = 'DLL')
    #ACCEPT
  #ELSE
    #REJECT
  #ENDIF
#ENDRESTRICT
#SHEET,HSCROLL,ADJUST
  #TAB('Applets')
	#BOXED('Control Panel')
		#DISPLAY('JaDu Technologies Control Panel Template.')
		#DISPLAY('')
		#DISPLAY('REMEBER: Change the .DLL to .CPL')
		#DISPLAY('before distribution to the.')
		#DISPLAY('System or System32 directory.')
		#DISPLAY('')
		#DISPLAY('This procedure requires a 32bit .RES file')
		#DISPLAY('that conatins an icon for each procedure')
		#DISPLAY('to be displayed in the Control Panel')
		#DISPLAY('and a string table conatining a short')
		#DISPLAY('name (show under the icon) and a')
		#DISPLAY('description (show on the Control Panel''s')
		#DISPLAY('status bar.)')
		#DISPLAY('')
	  #PROMPT('32 Bit Resource File',OPENDIALOG('Select Resource File','Resource Files|*.RES')),%JtCplResourceFile
      #DISPLAY('')
	  #BUTTON('Applet Procedures'),MULTI(%JtCplProcedures,%JtCplProcedure)
		#DISPLAY('Only include those procedures')
		#DISPLAY('That will be called directly')
		#DISPLAY('by Control Panel')
		#PROMPT('Procedure:',PROCEDURE),%JtCplProcedure,REQ
		#PROMPT('Icon Id.',@n4),%JtCplIcon,REQ
		#PROMPT('Short Name Id.',@n4),%JtCplShortName,REQ
		#PROMPT('Description Id.',@n4),%JtCplDescription,REQ
	  #ENDBUTTON
	#ENDBOXED  
  #ENDTAB
  #TAB('Copyright')
    #BOXED('Copyright Information')
      #DISPLAY(' ')
      #DISPLAY('                 Control Panel Templates')
      #DISPLAY('                 are produced by')
      #DISPLAY('                 JaDu Technologies')
      #DISPLAY('                 Australia')
      #DISPLAY(' ')
      #DISPLAY('                 Copyright 1999. All Rights Reserved')
      #DISPLAY(' ')
      #DISPLAY('                 This template is provided "As Is" and no')
      #DISPLAY('                 warrantee is implied by it''s use.')
      #DISPLAY('                 Re-Distribution without consent of the')
      #DISPLAY('                 author is illegal.')
      #DISPLAY(' ')
      #DISPLAY('                 email: stephenb@jadutech.com')
    #ENDBOXED
  #ENDTAB
#ENDSHEET  
%Procedure PROCEDURE(UNSIGNED hWndCpl,UNSINGED uMsg,LONG lParam1,LONG lParam2)
#PROTOTYPE('(UNSIGNED hWndCpl,UNSIGNED uMsg,LONG lParam1,LONG lParam2),LONG,PASCAL,NAME(''CPlApplet'')')
#SET(%JtCplRes1,'#message "Linking file ' & %JtCplResourceFile & ' file into the APP..."')
#SET(%JtCplRes2,'#pragma link(' & %JtCplResourceFile & ')')
#IF(FILEEXISTS(%JtCplResourceFile))
  #REMOVE((%Application & '.prj'))
  #CREATE((%Application & '.prj'))
%JtCplRes1
%JtCplRes2
  #CLOSE
#ELSE
  #ERROR('Resource file ' & upper(%JtCplResourceFile) & ' does not exist')
  #ABORT
#ENDIF

#INSERT(%FileControlInitialize(ABC))
#AT(%AfterGlobalIncludes)
CPL_INIT        equate(1)
CPL_GETCOUNT    equate(2)
CPL_INQUIRE     equate(3)
CPL_SELECT      equate(4)
CPL_DBLCLK      equate(5)
CPL_STOP        equate(6)
CPL_EXIT        equate(7)
CPL_NEWINQUIRE  equate(8)
CPL_SETUP       equate(200)

CPLINFO     GROUP,TYPE
idIcon        SIGNED         
idName        SIGNED         
idInfo        SIGNED
lData         LONG
            END

#ENDAT

#AT(%CustomGlobalDeclarations)
  #PROJECT(%Application & '.prj')
  #INSERT(%FileControlSetFlags(ABC))
#ENDAT
#AT(%GlobalMap),PRIORITY(4000)
  MODULE('JtCpl')
    JtCplMemCpy(LONG Dest,LONG Source,UNSIGNED tSize),RAW,NAME('_memcpy')
  END
#ENDAT

#FOR(%LocalData)
%[20]LocalData %LocalDataStatement
#ENDFOR
JtCPLINFO  LIKE(CPLINFO)
#EMBED(%DataSection,'Data Section'),DATA,TREE('Local Data{{PRIORITY(1000)}')
  CODE
  #EMBED(%ProcessedCodeBefore,'Code Before Handling Messages'),LABEL,%ActiveTemplateInstance,MAP(%ActiveTemplateInstance,%ActivetemplateInstanceDescription)
  case uMsg
  of CPL_INIT        
    return(1)  
  of CPL_GETCOUNT    
  #SET(%JtCplTotalProcedures,ITEMS(%JtCplProcedures))
    return(%JtCplTotalProcedures)
  of CPL_INQUIRE     
    execute lParam1 + 1
  #FOR(%JtCplProcedures)    
      begin
        JtCPLINFO.idIcon  = %JtCplIcon
        JtCPLINFO.idName = %JtCplShortName
        JtCPLINFO.idInfo = %JtCplDescription
        JtCPLINFO.lData = 0
      . 
  #ENDFOR
    .  
    JtCplMemCpy(lParam2,address(JtCPLINFO),size(JtCPLINFO))
  of CPL_SELECT      
  of CPL_DBLCLK      
    execute lParam1 + 1
  #FOR(%JtCplProcedures)    
      %JtCplProcedure
  #ENDFOR
    .
  of CPL_STOP        
  of CPL_EXIT        
  .
  return(0)

#EMBED(%ProcedureRoutines,'Procedure Routines'),LABEL,LABEL,%ActiveTemplateInstance,MAP(%ActiveTemplateInstance,%ActivetemplateInstanceDescription)
#INSERT(%LocalMapCheck(ABC))


