  MEMBER

   INCLUDE('JtQkfile.inc'),ONCE

   MAP
     MODULE('qfwin')
       JtQFCreate(*LPCSTR,DWORD,DWORD,LONG,DWORD,DWORD,HANDLE),HANDLE,PASCAL,RAW,NAME('CreateFileA')
!       JtQFCreate(*LPCSTR,DWORD,DWORD,*SECURITY_ATTRIBUTES,DWORD,DWORD,HANDLE),HANDLE,PASCAL,RAW,NAME('CreateFileA')
!       JtQFCreate(*LPCSTR,SIGNED),HFILE,PASCAL,RAW,NAME('_lcreat')
       JtQFWrite(HANDLE,LPCVOID,DWORD,*DWORD,ULONG),BOOL,PASCAL,RAW,NAME('WriteFile')
!       JtQFWrite(HFILE,*LPCSTR,UNSIGNED),UNSIGNED,PASCAL,RAW,NAME('_lwrite')
       JtQFClose(HANDLE),BOOL,PASCAL,NAME('CloseHandle')
       JtQfRead(HANDLE,LPVOID,DWORD,*DWORD,LONG),BOOL,PASCAL,RAW,NAME('ReadFile')
!       JtQfRead(HANDLE,LPVOID,DWORD,*DWORD,*OVERLAPPED),BOOL,PASCAL,RAW,NAME('ReadFile')
!       JtQFClose(HFILE),HFILE,PASCAL,NAME('_lclose')
!       JtQFSeek(HFILE, LONG, SIGNED),LONG,PASCAL,NAME('_llseek')
        JtQFSetOEF(HANDLE),BOOL,PASCAL,NAME('SetEndOfFile')
        JtQFSetFilePointer(HANDLE,LONG DistanceToMove,LONG DistanceToMoveHigh,DWORD MoveMethod),DWORD,PASCAL,NAME('SetFilePointer'),PROC
        JtQFGetFileSize(HANDLE,*DWORD),DWORD,PASCAL,NAME('GetFileSize')
     .  
   .

JtQuickFileClass.Insert     PROCEDURE(STRING Text,BYTE TerminateLine = True)
BytesWritten DWORD
CRLF    CSTRING('<13,10>')
  CODE
  if not SELF.FileOpen
    return
  .
  if len(clip(Text))
    if JtQFWrite(SELF.FileHandle,address(Text),len(Text),BytesWritten,0); .
  .  
  if TerminateLine
    if JtQFWrite(SELF.FileHandle,address(CRLF),2,BytesWritten,0); .
  .  
  if not SELF.SaveBuffer &= NULL
    dispose(SELF.SaveBuffer)
  .
  SELF.SaveBuffer &= new CSTRING(len(Text) + 1)
  SELF.SaveBuffer = Text

JtQuickFileClass.Close      PROCEDURE(BYTE RemoveFile = 0)
  CODE
  if not SELF.FileOpen
    return
  .  
  if JtQFSetOEF(SELF.FileHandle); .
  if JtQFClose(SELF.FileHandle);.
  clear(SELF.FileHandle)
  SELF.FileOpen = False
  if RemoveFile
    remove(SELF.FileName)
  .  

JtQuickFileClass.Delete     PROCEDURE
  CODE
  if SELF.FileOpen
    SELF.Close()
  .
  remove(SELF.FileName)
  
JtQuickFileClass.Destruct   PROCEDURE
  CODE
  if SELF.FileOpen
    SELF.Close()
  .
  if not SELF.SaveBuffer &= NULL
    dispose(SELF.SaveBuffer)
  .  
  
JtQuickFileClass.GetName    PROCEDURE(BYTE FileNameOnly = 0)!,STRING
Counter  LONG,AUTO
  CODE
  if not FileNameOnly
    return(SELF.FileName)
  .
  loop Counter = len(clip(SELF.FileName)) to 1 by -1
    if SELF.FileName[Counter] = '\'
      break
    .
  .
  if Counter > 1
    return(SELF.FileName[Counter + 1 : len(clip(SELF.FileName))])
  else
    return(clip(SELF.FileName))
  .
  
JtQuickFileClass.GetHandle        PROCEDURE!,HANDLE  
  CODE
  return(SELF.FileHandle)
  
JtQuickFileClass.GetSize              PROCEDURE!,LONG
dwSize  DWORD
  CODE
  if not SELF.FileOpen
    return(-1) 
  .
  return(JtQFGetFileSize(SELF.FileHandle,dwSize))

JtQuickFileClass.Open       PROCEDURE(STRING szFileName,BYTE SetToEOF = 0)!,BYTE
  CODE
  if SELF.FileOpen
    return(SELF.FileOpen) 
  .
  SELF.FileName = szFileName
  SELF.FileHandle = JtQFCreate(SELF.FileName,JtQfGENERIC_READ + JtQfGENERIC_WRITE,JtQfFILE_SHARE_READ + JtQfFILE_SHARE_WRITE,0,JtQfOPEN_ALWAYS,JtQfFILE_ATTRIBUTE_ARCHIVE,0)
  if SELF.FileHandle
    SELF.FileOpen = True
  .  
  if SetToEOF and SELF.FileOpen
    JtQFSetFilePointer(SELF.FileHandle,0,0,JtQfFILE_END) 
!    JtQFSetFilePointer(SELF.FileHandle,SELF.GetSize(),0,JtQfFILE_BEGIN)
  .
  return(SELF.FileOpen)

JtQuickFileClass.Opened              PROCEDURE!,BYTE
  CODE
  return(SELF.FileOpen)

JtQuickFileClass.Read   PROCEDURE(*STRING szTarget,LONG nStart = 0)
nBytesRead  ULONG,AUTO
szBuffer    &CSTRING
nReadLen    LONG,AUTO
  CODE
  if nStart
    JtQFSetFilePointer(SELF.FileHandle,nStart,0,JtQfFILE_BEGIN)
  .
  if (size(szTarget) - 1) < SELF.GetSize()
    nReadLen = size(szTarget) - 1
  else  
    nReadLen = SELF.GetSize()
  .
  szBuffer &= new CSTRING(nReadLen + 1)
  if not JtQfRead(SELF.FileHandle,szBuffer,nReadLen,nBytesRead,0)
    nBytesRead = 0
  .
  if nBytesRead
    szTarget = szBuffer[1 : nBytesRead]
  .  
  dispose(szBuffer)
  return(nBytesRead)

JtQuickFileClass.Read   PROCEDURE(*CSTRING szTarget,LONG nStart = 0)
nBytesRead  ULONG,AUTO
szBuffer    &CSTRING
nReadLen    LONG,AUTO
  CODE
  if nStart
    JtQFSetFilePointer(SELF.FileHandle,nStart,0,JtQfFILE_BEGIN)
  .
  if (size(szTarget) - 1) < SELF.GetSize()
    nReadLen = size(szTarget) - 1
  else  
    nReadLen = SELF.GetSize()
  .
  szBuffer &= new CSTRING(nReadLen + 1)
  if not JtQfRead(SELF.FileHandle,szBuffer,nReadLen,nBytesRead,0)
    nBytesRead = 0
  .
  if nBytesRead
    szTarget = szBuffer[1 : nBytesRead]
  .  
  dispose(szBuffer)
  return(nBytesRead)

JtQuickFileClass.Read   PROCEDURE(*IDynStr dsTarget,LONG nLength = 0,LONG nStart = 0)
nBytesRead  ULONG,AUTO
szBuffer    &CSTRING
nReadLen    LONG,AUTO
  CODE
  if nStart
    JtQFSetFilePointer(SELF.FileHandle,nStart,0,JtQfFILE_BEGIN)
  .
  if nLength
    nReadLen = nLength
  else  
    nReadLen = SELF.GetSize()
  .
  szBuffer &= new CSTRING(nReadLen + 1)
  if not JtQfRead(SELF.FileHandle,address(szBuffer),nReadLen,nBytesRead,0)
    nBytesRead = 0
  .
  if nBytesRead
    dsTarget.Cat(szBuffer[1 : nBytesRead])
  .  
  dispose(szBuffer)
  return(nBytesRead)
  
JtQuickFileClass.SetBOF     PROCEDURE  
  CODE
  JtQFSetFilePointer(SELF.FileHandle,0,0,JtQfFILE_BEGIN)
  
JtQuickFileClass.SetName    PROCEDURE(STRING szFileName)
  CODE
  if SELF.Opened()
    return(False)
  .
  SELF.FileName = szFileName
  return(True)
  
JtQuickFileClass.Str        PROCEDURE !,STRING  
  CODE
  if not SELF.SaveBuffer &= NULL
    return(SELF.SaveBuffer)
  else
    return('')
  .  
  
  