  MEMBER
    include('winequ.clw')

    MAP
      module('winapi')
    GetSystemMetrics( SIGNED),SIGNED,PASCAL
    GetWindowRect(HWND, *RECT),PASCAL,RAW
      .
    .
    INCLUDE('winmove.inc')


ssWinMove.Init   PROCEDURE(WINDOW WindowLabel,UNSIGNED Ctrl,LONG StdHeight,LONG MinHeight,LONG StdWidth,LONG MinWidth)

  code
  SELF.CQ &= new ssControlQ
  SELF.BarCtrl = Ctrl
  SELF.WinLabel &= WindowLabel
  SELF.StdHeight = StdHeight
  SELF.SaveMinHeight = MinHeight
  SELF.StdWidth = StdWidth
  SELF.SaveMinWidth = MinWidth
  SELF.WinLabel{PROP:MinHeight} = SELF.SaveMinHeight
  SELF.WinLabel{PROP:MinWidth} = SELF.SaveMinWidth
  SELF.WinCaption = SELF.WinLabel{PROP:Text}

ssWinMove.Destruct PROCEDURE

  code
  dispose(SELF.CQ)

ssWinMove.WinMoved    PROCEDURE

  code
  if SELF.WinLabel{PROP:xPos} =< 0 and SELF.WinLabel{PROP:yPos} > 2
    SELF.LeftVtWin
    do ProcedureReturn
  .
  if SELF.WinLabel{PROP:yPos} =< 0 and SELF.WinLabel{PROP:xPos} > 2
    SELF.TopHzWin
    do ProcedureReturn
  .
  GetWindowRect(SELF.WinLabel{PROP:Handle},SELF.WinRect)
  if SELF.WinRect.Right >= GetSystemMetrics(0) and SELF.WinRect.Bottom < GetSystemMetrics(1) - 2
    SELF.RightVtWin
    do ProcedureReturn
  .

ProcedureReturn     routine
  return

ssWinMove.LeftVtWin         PROCEDURE

  code
  if SELF.WinSized
    do ProcedureReturn
  .
  SELF.Winsized = True
  SELF.SaveWinSize
  SELF.ClearCaption
 OMIT('***',_WIDTH32_)
  SELF.WinLabel{PROP:xPos} = 0
 ***
 COMPILE('***',_WIDTH32_)
  SELF.WinLabel{PROP:xPos} = -2
 ***
  SELF.WinLabel{PROP:MinWidth} = SELF.StdWidth
  SELF.WinLabel{PROP:Width} = SELF.StdWidth
  v# = 0
  SELF.FreeQ
  settarget(SELF.WinLabel)
  loop i# = firstfield() to lastfield()
    SELF.SaveCqPos(i#)
    setposition(i#,0,v#)
    v# += i#{PROP:Height}
  .
  SELF.WinLabel{PROP:Height} = v#
  SELF.WindowPos = 1

ProcedureReturn     routine
  return

ssWinMove.TopHzWin            PROCEDURE

  code
  if SELF.WinSized
    do ProcedureReturn
  .
  SELF.Winsized = True
  SELF.SaveWinSize
  SELF.ClearCaption
 OMIT('***',_WIDTH32_)
  SELF.WinLabel{PROP:yPos} = -2
 ***
 COMPILE('***',_WIDTH32_)
  SELF.WinLabel{PROP:yPos} = -3
 ***
  SELF.WinLabel{PROP:MinHeight} = SELF.StdHeight
  SELF.WinLabel{PROP:Height} = SELF.StdHeight
  v# = 0
  SELF.FreeQ
  settarget(SELF.WinLabel)
  loop i# = firstfield() to lastfield()
    SELF.SaveCqPos(i#)
    setposition(i#,v#,0)
    v# += i#{PROP:Width}
  .
  SELF.WinLabel{PROP:Width} = v#
  SELF.WindowPos = 3

ProcedureReturn     routine
  return

ssWinMove.RightVtWin          PROCEDURE

  code
  if SELF.WinSized
    do ProcedureReturn
  .
  SELF.Winsized = True
  SELF.SaveWinSize
  SELF.ClearCaption
  GetWindowRect(SELF.WinLabel{PROP:Handle},SELF.WinRect)
  SELF.WinLabel{PROP:xPos} = round(GetSystemMetrics(0)/round((SELF.WinRect.Right - |
                             SELF.WinRect.Left) / SELF.WinLabel{PROP:Width},.1),1)  - |
                             SELF.StdWidth
!  SELF.WinLabel{PROP:xPos} = GetSystemMetrics(0)/(SELF.WinRect.Right - |
!                             SELF.WinRect.Left) / SELF.WinLabel{PROP:Width}  - |
!                             (SELF.StdWidth)
  SELF.WinLabel{PROP:MinWidth} = SELF.StdWidth
  SELF.WinLabel{PROP:Width} = SELF.StdWidth
  v# = 0
  SELF.FreeQ
  loop i# = firstfield() to lastfield()
    SELF.SaveCqPos(i#)
    setposition(i#,0,v#)
    v# += i#{PROP:Height}
  .
  SELF.WinLabel{PROP:Height} = v#
  SELF.WindowPos = 2

ProcedureReturn     routine
  return

ssWinMove.SaveWinSize        PROCEDURE

  code
  SELF.SaveWidth = SELF.WinLabel{PROP:Width}
  SELF.SaveHeight = SELF.WinLabel{PROP:Height}
  SELF.SaveMinWidth = SELF.WinLabel{PROP:MinWidth}
  SELF.SaveMinHeight = SELF.WinLabel{PROP:MinHeight}

ssWinMove.ClearCaption        PROCEDURE

  code
  SELF.WinLabel{PROP:Resize} = ''
  SELF.WinLabel{PROP:Text} = ''

ssWinMove.SaveCqPos       PROCEDURE(LONG CtrlUse)

  code
  SELF.CQ.Id = CtrlUse
  SELF.CQ.xPos = CtrlUse{PROP:xPos}
  SELF.CQ.yPos = CtrlUse{PROP:yPos}
  add(SELF.CQ)

ssWinMove.RegionAccept    PROCEDURE

  code
  if SELF.WindowPos
    execute SELF.WindowPos
      SELF.MousePos = mousex()
      SELF.MousePos = mousex()
      SELF.MousePos = mousey()
    .
    SELF.MouseDown = True
  .

ssWinMove.RegionMouseUp   PROCEDURE

  code
  SELF.MouseDown = False
  if SELF.WinLabel{PROP:Text}
    SELF.WindowPos = 0
  .
ssWinMove.RegionMouseMove PROCEDURE

  code
  if SELF.MouseDown
    SELF.CheckWinMove
  .

ssWinMove.CheckWinMove        PROCEDURE

  code
  if not SELF.WindowPos
    do ProcedureReturn
  .
  execute SELF.WindowPos
    begin
     if mousex() > SELF.MousePos + 2
        SELF.ResetCaption
        SELF.RestoreWinSize
        SELF.RestoreCqPos
        SELF.WinLabel{PROP:xPos} = 2
        SELF.MouseDown = False
      .
    .
    begin
     if mousex() < SELF.MousePos - 2
        SELF.ResetCaption
        SELF.RestoreWinSize
        SELF.RestoreCqPos
        SELF.WinLabel{PROP:xPos} = SELF.WinLabel{PROP:xPos} - SELF.WinLabel{PROP:Width}
        SELF.MouseDown = False
      .
    .
    begin
      if mousey() > SELF.MousePos + 2
        SELF.ResetCaption
        SELF.RestoreWinSize
        SELF.RestoreCqPos
        SELF.WinLabel{PROP:yPos} = 10
        SELF.MouseDown = False
      .
    .
  .

ProcedureReturn     routine
  return

ssWinMove.ResetCaption        PROCEDURE

  code
  SELF.WinLabel{PROP:Resize} = True
  SELF.WinLabel{PROP:Text} = SELF.WinCaption

ssWinMove.RestoreCqPos        PROCEDURE

  code
  loop i# = 1 to records(SELF.CQ)
    get(SELF.CQ,i#)
    setposition(SELF.CQ.Id,SELF.CQ.xPos,SELF.CQ.yPos)
  .

ssWinMove.RestoreWinSize      PROCEDURE

  code
  SELF.WinLabel{PROP:Width} = SELF.SaveWidth
  SELF.WinLabel{PROP:Height} = SELF.SaveHeight
  SELF.WinLabel{PROP:MinWidth} = SELF.SaveMinWidth
  SELF.WinLabel{PROP:MinHeight} = SELF.SaveMinHeight
  SELF.WinSized = False

ssWinMove.FreeQ         PROCEDURE

  code
  if not records(SELF.CQ); return.
  loop i# = records(SELF.CQ) to 1 by -1
    get(SELF.CQ,i#)
    delete(SELF.CQ)
  .
